/*---------------------------------------------------------------------------*\

    FILE....: twovpb8l.cpp
    TYPE....: C++ Program
    AUTHOR..: David Rowe
    DATE....: 1/11/00

    Demonstrates starting two VPB8Ls.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include "../src/vpbapi.h"
#include "../src/verbose.h"

#define NUM_CARDS 2
#define CH_CARD   8
#define NUM_CH (NUM_CARDS*CH_CARD)

int kbhit();

int main() {
	int       iobase[] = {0x300, 0x310};
	int       h[NUM_CH];
	VPB_EVENT e;
	char	  s[VPB_MAX_STR];
	int       i, ret, bd, ch;

	// initialise

	verbose(1);
	vpb_seterrormode(VPB_DEVELOPMENT);
	vpb_config(NUM_CARDS, iobase, "../firmware/vlcmain.out", VPB_VPB8L);
	
	for(i=0; i<NUM_CH; i++) {
		bd = 1 + (i/CH_CARD);
		ch = 1 + (i % CH_CARD);
		printf("starting bd: %d  ch: %d\n", bd, ch);
		h[i] = vpb_open(bd, ch);
	}

	// print out events until return is hit

	do {
		ret = vpb_get_event_async(&e);
		if (ret == VPB_OK) {
			vpb_translate_event(&e, s);
			printf("%s",s);
		}
		vpb_sleep(100);

	} while(!kbhit());

	for(i=0; i<NUM_CH; i++) {
		vpb_close(h[i]);
	}

	return 0;
}

